// require.config.js, require.intellisense.js
// Microsoft grants you the right to use these script files for the sole purpose of either: (i) interacting
// through your browser with the Microsoft website or online service, subject to the applicable licensing or
// use terms; or (ii) using the files as included with a Microsoft product subject to that products license
// terms. Microsoft reserves all other rights to the files not expressly granted by Microsoft, whether by implication,
// estoppel or otherwise. The notices and licenses below are for informational purposes only.
// Portions of this code are based on RequireJS 2.1.2 Copyright (c) 2010-2014, The Dojo Foundation All Rights Reserved.

// Provided for Informational Purposes Only
// MIT License
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy,
// modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software
// is furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
// IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

(function () {
    var redirect = intellisense.redirectDefinition;
    var deferredDefines = [];
    var deferredRequires = [];
    var moduleMap = [];
    var relativeToHtml = null;
    var isConfigSet = false;
    var isBaseUrlDefined = false;
    var primaryFilePath = null;
    var jsExt = ".js";

    // RequireJS regular expressions for CommonJS
    var commentRegExp = /(\/\*([\s\S]*?)\*\/|([^:]|^)\/\/(.*)$)/mg;
    var cjsRequireRegExp = /[^.]\s*require\s*\(\s*["']([^'"\s]+)["']\s*\)/g;

    // Ensure RequireJS is defined
    if (typeof requirejs === "undefined") {
        return;
    }

    // Disable RequireJS script loading timeouts
    require.config({ waitSeconds: 0 });

    // Store the original RequireJS functions
    var originalConfig = requirejs.config;
    var originalLoad = requirejs.load;
    var originalRequire = window.require;
    var originalDefine = window.define;
    var originalCreateNode = requirejs.createNode;
    var originalNextTick = requirejs.nextTick;
    var originalVersion = requirejs.version;
    var originalS = requirejs.s;
    var originalJSExtRegExp = requirejs.jsExtRegExp;
    var originalIsBrowser = requirejs.isBrowser;
    var originalDefaultOnError = requirejs.onError;
    var originalExec = requirejs.exec;

    function isArray(obj) {
        return Object.prototype.toString.call(obj) === "[object Array]";
    }

    function isFunction(obj) {
        return Object.prototype.toString.call(obj) === '[object Function]';
    }

    function convertRelativeDepsToAbsolute(deps) {
        if (isArray(deps)) {
            for (var i = 0; i < deps.length; i++) {
                deps[i] = convertRelativeDepToAbsolute(deps[i]);
            }
        }
    }

    function convertRelativeDepToAbsolute(dep) {
        var finalDep = dep;
        var scriptFilePath = intellisense.executingScriptFileName;
        if (typeof scriptFilePath !== "undefined" &&
            typeof _$requirejs_rootPath !== "undefined" &&
            typeof dep === "string" &&
            dep.indexOf("./") === 0) {
            finalDep = (scriptFilePath.substring(_$requirejs_rootPath.length - 1, scriptFilePath.lastIndexOf('\\')) + "/" + dep.substring(2)).replace(/[\\]+/g, '/');
        }
        return finalDep;
    }

    // Determines if the script is being executed from a project type that
    // infers references from markup files. If so paths are relative to html.
    function isRelativeToHtml() {
        intellisense.progress();

        if (relativeToHtml === null) {
            var scripts = document.getElementsByTagName("script");
            if (scripts) {
                for (var i = 0; i < scripts.length; i++) {
                    var script = scripts[i];
                    var fileName = script.src.replace(/^.*(\/|\\)/, '');
                    if (fileName.toLowerCase().indexOf("require") !== -1) {
                        relativeToHtml = true;
                        return relativeToHtml;
                    }
                }
            }
            relativeToHtml = false;
        }
        return relativeToHtml;
    }

    // Used to convert a url path that is relative to the base url to
    // be relative to the file.
    function makeRelativeToFile(url) {
        intellisense.progress();

        var scriptFilePath = intellisense.executingScriptFileName;
        if (typeof scriptFilePath === 'undefined') {
            return url;
        }

        var startPath;
        if (url.indexOf('/') === 0) {
            // If the url is absolute the start path is the 
            // root path of the project or website.
            startPath = _$requirejs_rootPath;
        } else if (isBaseUrlDefined || _$requirejs_dataMain === "") {
            // Else if a baseUrl has been user defined, or no
            // data-main path was specified, the start path will be
            // the location of the HTML page that loads RequireJS.
            startPath = _$requirejs_startPagePath;
        } else {
            // Otherwise the start path is specified
            // in the data main attribute.
            startPath = _$requirejs_dataMainPath;
        }

        // The start path should never be undefined or empty.
        // If it is return the original url.
        if (typeof startPath === "undefined" || startPath === "") {
            return url;
        }

        var i;
        var scriptPath = normalize(startPath.substr(0, startPath.lastIndexOf("/") + 1) + url);
        var scriptParts = scriptPath.split('\\');
        var currentParts = scriptFilePath.toLowerCase().split('\\');

        for (i = 1; i < currentParts.length; i++) {
            if (currentParts[i] !== scriptParts[i]) {
                break;
            }
        }

        var prefix = "";
        var baseUrl = scriptParts.slice(i, scriptPath.length - 1).join('/');
        var dots = currentParts.length - 1 - i;

        if (dots === 0) {
            prefix = "./";
        } else {
            for (i = 0 ; i < dots; i++) {
                prefix += "../";
            }
        }

        return prefix + baseUrl;
    }

    function normalize(url) {
        if (typeof url !== "string" || url.length === 0 || url === '/') {
            return '';
        }

        var originalParts = url.replace(/[\/]+/g, '\\').toLowerCase().split('\\');
        var finalParts = [];

        // Normalize the url by removing '..', '.' and ''
        for (var i = 0; i < originalParts.length; i++) {
            var part = originalParts[i];
            if (part === "..") {
                finalParts.pop();
            } else if (part !== '' && part !== '.') {
                finalParts.push(part);
            }
        }

        // Return the normalized url (ex: a\b\c)
        return finalParts.join('\\');
    }

    function getPrimaryFile() {
        if (primaryFilePath === null) {
            // Set the primary file path. If it isn't explicitly specified default to the current executing script file path.
            primaryFilePath = (typeof _$requirejs_primaryFilePath !== "undefined") ? _$requirejs_primaryFilePath.replace(/[\/]+/g, '\\').toLowerCase() : intellisense.executingScriptFileName.toLowerCase();
        }
        return primaryFilePath;
    }

    function tryDefineModule(filePath, normalizedUrl, moduleName, deps, callback) {
        if (filePath.toLowerCase().indexOf(normalizedUrl, filePath.length - normalizedUrl.length) !== -1) {
            if (isArray(deps)) {
                originalDefine.call(window, moduleName, deps, callback);
            } else {
                originalDefine.call(window, moduleName, callback);
            }

            return true;
        }

        return false;
    }

    function processDeferredRequires(scriptFilePath) {
        // The executing script file name should never be undefined 
        // except for unit tests.
        if (typeof scriptFilePath === 'undefined' ||
           (!isConfigSet && scriptFilePath.toLowerCase() === getPrimaryFile())) {
            isConfigSet = true;

            // Call the requires in the order they were deferred
            for (var i = 0; i < deferredRequires.length; i++) {
                var deferred = deferredRequires[i];
                originalRequire.call(window, deferred.deps, deferred.callback);
            }
            deferredRequires = [];
        }
    }

    // Define a module that is used for RequireJS plugins. 
    // Return a string for all RequireJS plugin resource 
    // dependencies to avoid timeouts.
    define("__RequireJSPlugin", function () { return ""; });

    // Redefine: define(name, deps, callback)
    define = function (name, deps, callback) {
        var i;

        // Call progress to avoid timeouts
        intellisense.progress();

        // Anonymous module 
        if (typeof name !== "string") {
            // Shift arguments
            callback = deps;
            deps = name;
            name = null;
        }

        if (isArray(deps)) {
            // Replace RequireJS Plugin! dependencies with our custom plugin module
            for (i = 0; i < deps.length; i++) {
                var dep = deps[i];
                if (typeof dep === "string" && dep.indexOf("!") !== -1) {
                    deps[i] = "__RequireJSPlugin";
                }
            }
        } else {
            // Module has no dependencies
            // Shift arguments
            callback = deps;
            deps = null;
        }

        // Retrieve CommonJS dependencies
        if (!deps && isFunction(callback)) {
            deps = [];
            if (callback.length) {
                callback
                    .toString()
                    .replace(commentRegExp, '')
                    .replace(cjsRequireRegExp, function (match, dep) {
                        deps.push(dep);
                    });

                deps = (callback.length === 1 ? ['require'] : ['require', 'exports', 'module']).concat(deps);

                // Wrap the define callback in a function that transforms relative
                // dependency paths to absolute paths before calling the original callback.
                var originalCallback = callback;
                callback = function (require) {
                    var transformPaths = function (path) {
                        return require(convertRelativeDepToAbsolute(path));
                    };
                    return originalCallback(transformPaths);
                };
            }
        }

        // Transform relative require dependency paths to be absolute.
        convertRelativeDepsToAbsolute(deps);

        // Require the define dependencies
        if (isArray(deps) && deps.length > 0) {
            if (isConfigSet) {
                require(deps, callback);
            } else {
                deferredRequires.push({ deps: deps, callback: callback });
            }
        }

        // Process the deferred required dependencies before defining
        // the module to ensure the dependencies are loaded.
        var scriptFilePath = intellisense.executingScriptFileName;
        processDeferredRequires(scriptFilePath);

        // If this is a named module there is no need to defer the define.
        // Call the original define immediately.
        if (typeof name === "string") {
            if (isArray(deps)) {
                originalDefine.call(window, name, deps, callback);
            } else {
                originalDefine.call(window, name, callback);
            }
            return;
        }

        // Otherwise, defer the define until the mapping has been established
        deferredDefines.push({ path: scriptFilePath, name: name, deps: deps, callback: callback });

        // Check to see if the path has already been mapped to a module name
        for (i = 0 ; i < moduleMap.length; i++) {
            var normalizedUrl = moduleMap[i].url;
            var moduleName = (typeof name === "string") ? name : moduleMap[i].moduleName;

            if (tryDefineModule(scriptFilePath, normalizedUrl, moduleName, deps, callback)) {
                return;
            }
        }
    };

    // Apply the original defines AMD property to
    // ensure jQuery modules are mapped correctly.
    if (originalDefine.amd) {
        define.amd = originalDefine.amd;
    }

    require = function (deps, callback) {
        // Call progress to avoid timeouts
        intellisense.progress();

        var scriptFilePath = intellisense.executingScriptFileName;
        processDeferredRequires(scriptFilePath);

        // Transform relative require dependency paths to be absolute.
        convertRelativeDepsToAbsolute(deps);

        if (!isConfigSet) {
            deferredRequires.push({ deps: deps, callback: callback });
            return;
        }

        originalRequire.call(window, deps, callback);
    };

    // Redefine: config(configObj)
    var isDataMainSet = false;
    require.config = requirejs.config = function (configObj) {
        // Call progress to avoid timeouts
        intellisense.progress();

        var scriptFileName = intellisense.executingScriptFileName;
        if (typeof scriptFileName === "string" &&
            scriptFileName.indexOf("require.config.js") !== -1) {
            // config() called from require.config.js
            // sets data-main and default baseUrl
            // this only needs to be done once to avoid
            // overwriting user defined config() calls
            if (!isDataMainSet) {
                configObj.waitSeconds = 0;
                originalConfig(configObj);
            }
        } else {
            // config() called from user code
            if (typeof configObj.baseUrl !== "undefined") {
                isBaseUrlDefined = true;
            }

            configObj.waitSeconds = 0;
            originalConfig(configObj);
        }

        isDataMainSet = true;
    };

    // Redefine: load(context, moduleName, url)
    require.load = requirejs.load = function (context, moduleName, url) {
        // Call progress to avoid timeouts
        intellisense.progress();

        // Ensure the url ends with a .js extension
        if (url.toLowerCase().indexOf(jsExt, this.length - jsExt.length) === -1) {
            url += jsExt;
        }

        // Add the module name and normalized url mapping to the module map.
        var normalizedUrl = normalize(url);
        moduleMap.push({ url: normalizedUrl, moduleName: moduleName });

        // If there is a deferred define that matches the normalized url, define it using the specified module name.
        for (var i = 0 ; i < deferredDefines.length; i++) {
            var scriptFilePath = deferredDefines[i].path;
            if (tryDefineModule(scriptFilePath, normalizedUrl, moduleName, deferredDefines[i].deps, deferredDefines[i].callback)) {
                break;
            }
        }

        // When the data-main attribute is defined in a /// reference instead of an 
        // HTML page adjust the url to be relative to the referencing file.
        if (!isRelativeToHtml()) {
            url = makeRelativeToFile(url);
        }

        originalLoad.call(window, context, moduleName, url);
    };

    require.nextTick = requirejs.nextTick = originalNextTick;
    require.version = requirejs.version = originalVersion;
    require.s = requirejs.s = originalS;
    require.jsExtRegExp = requirejs.jsExtRegExp = originalJSExtRegExp;
    require.isBrowser = requirejs.isBrowser = originalIsBrowser;
    require.onError = requirejs.onError = originalDefaultOnError;
    require.createNode = requirejs.createNode = originalCreateNode;
    require.exec = requirejs.exec = originalExec;

    // Restore the original require functions
    redirect(define, originalDefine);
    redirect(require, originalRequire);
    redirect(requirejs, originalRequire);
})();

// SIG // Begin signature block
// SIG // MIIkFgYJKoZIhvcNAQcCoIIkBzCCJAMCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // WhwDV3sFYac0HNp/4RpZXvDoeXhB+BoQTFCwgKzCUT2g
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFdswghXXAgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCggcYwGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIFo99gJTroY688ujbc2xL1w5WcANfkvokNvBNh9C
// SIG // pOkjMFoGCisGAQQBgjcCAQwxTDBKoDCALgByAGUAcQB1
// SIG // AGkAcgBlAC4AaQBuAHQAZQBsAGwAaQBzAGUAbgBzAGUA
// SIG // LgBqAHOhFoAUaHR0cDovL21pY3Jvc29mdC5jb20wDQYJ
// SIG // KoZIhvcNAQEBBQAEggEApKXtLHHvWfA6R5FiskGQWbFe
// SIG // NhHzQNphdPo5i2Eok+I4l1w9MQoseHQYH2/kGeWLPtKk
// SIG // 7zxKc6MRmvwrWcp1kL2hHUHoNGHWkmoPoQtxlZv3Q1/y
// SIG // /pl92CU82dsm8s4n19aGXhdZpzHmJSIQraRa2nTHfl9h
// SIG // ndOFk3eAjh17y83xoyA9j3Z/2Om302rqdc1aAoqpI6Ev
// SIG // k0MYGV33+pN0mHSYSIKf5Fgxt2Xy/2+2cmXCGXSNc8+S
// SIG // f8isHCbRNDapESqYVNzAnHGzBNfWPZ2n+Lm1+uUivoBp
// SIG // Rg4RP9aM8deoGct6Pf3TZozJl0VDL7W8lSQbkaE6m40q
// SIG // 3PQKiunbkKGCE00wghNJBgorBgEEAYI3AwMBMYITOTCC
// SIG // EzUGCSqGSIb3DQEHAqCCEyYwghMiAgEDMQ8wDQYJYIZI
// SIG // AWUDBAIBBQAwggE9BgsqhkiG9w0BCRABBKCCASwEggEo
// SIG // MIIBJAIBAQYKKwYBBAGEWQoDATAxMA0GCWCGSAFlAwQC
// SIG // AQUABCDGC5S1fK5tzNkIR9pG3TXh2xQyCzb/RR2z57Ed
// SIG // dr/Z3wIGWIuRw2BwGBMyMDE3MDIwOTAzNDMzMS43NzNa
// SIG // MAcCAQGAAgH0oIG5pIG2MIGzMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lw
// SIG // aGVyIERTRSBFU046QjFCNy1GNjdGLUZFQzIxJTAjBgNV
// SIG // BAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Wg
// SIG // gg7QMIIGcTCCBFmgAwIBAgIKYQmBKgAAAAAAAjANBgkq
// SIG // hkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMxEzARBgNV
// SIG // BAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1vbmQx
// SIG // HjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlvbjEy
// SIG // MDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2VydGlmaWNh
// SIG // dGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAwNzAxMjEzNjU1
// SIG // WhcNMjUwNzAxMjE0NjU1WjB8MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGltZS1TdGFt
// SIG // cCBQQ0EgMjAxMDCCASIwDQYJKoZIhvcNAQEBBQADggEP
// SIG // ADCCAQoCggEBAKkdDbx3EYo6IOz8E5f1+n9plGt0VBDV
// SIG // pQoAgoX77XxoSyxfxcPlYcJ2tz5mK1vwFVMnBDEfQRsa
// SIG // lR3OCROOfGEwWbEwRA/xYIiEVEMM1024OAizQt2TrNZz
// SIG // MFcmgqNFDdDq9UeBzb8kYDJYYEbyWEeGMoQedGFnkV+B
// SIG // VLHPk0ySwcSmXdFhE24oxhr5hoC732H8RsEnHSRnEnIa
// SIG // IYqvS2SJUGKxXf13Hz3wV3WsvYpCTUBR0Q+cBj5nf/Vm
// SIG // wAOWRH7v0Ev9buWayrGo8noqCjHw2k4GkbaICDXoeByw
// SIG // 6ZnNPOcvRLqn9NxkvaQBwSAJk3jN/LzAyURdXhacAQVP
// SIG // Ik0CAwEAAaOCAeYwggHiMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBTVYzpcijGQ80N7fEYbxTNoWoVtVTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBTV9lbLj+iiXGJo0T2UkFvXzpoYxDBWBgNVHR8ETzBN
// SIG // MEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXRfMjAx
// SIG // MC0wNi0yMy5jcmwwWgYIKwYBBQUHAQEETjBMMEoGCCsG
// SIG // AQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NlcnRzL01pY1Jvb0NlckF1dF8yMDEwLTA2LTIz
// SIG // LmNydDCBoAYDVR0gAQH/BIGVMIGSMIGPBgkrBgEEAYI3
// SIG // LgMwgYEwPQYIKwYBBQUHAgEWMWh0dHA6Ly93d3cubWlj
// SIG // cm9zb2Z0LmNvbS9QS0kvZG9jcy9DUFMvZGVmYXVsdC5o
// SIG // dG0wQAYIKwYBBQUHAgIwNB4yIB0ATABlAGcAYQBsAF8A
// SIG // UABvAGwAaQBjAHkAXwBTAHQAYQB0AGUAbQBlAG4AdAAu
// SIG // IB0wDQYJKoZIhvcNAQELBQADggIBAAfmiFEN4sbgmD+B
// SIG // cQM9naOhIW+z66bM9TG+zwXiqf76V20ZMLPCxWbJat/1
// SIG // 5/B4vceoniXj+bzta1RXCCtRgkQS+7lTjMz0YBKKdsxA
// SIG // QEGb3FwX/1z5Xhc1mCRWS3TvQhDIr79/xn/yN31aPxzy
// SIG // mXlKkVIArzgPF/UveYFl2am1a+THzvbKegBvSzBEJCI8
// SIG // z+0DpZaPWSm8tv0E4XCfMkon/VWvL/625Y4zu2JfmttX
// SIG // QOnxzplmkIz/amJ/3cVKC5Em4jnsGUpxY517IW3DnKOi
// SIG // PPp/fZZqkHimbdLhnPkd/DjYlPTGpQqWhqS9nhquBEKD
// SIG // uLWAmyI4ILUl5WTs9/S/fmNZJQ96LjlXdqJxqgaKD4kW
// SIG // umGnEcua2A5HmoDF0M2n0O99g/DhO3EJ3110mCIIYdqw
// SIG // UB5vvfHhAN/nMQekkzr3ZUd46PioSKv33nJ+YWtvd6mB
// SIG // y6cJrDm77MbL2IK0cs0d9LiFAR6A+xuJKlQ5slvayA1V
// SIG // mXqHczsI5pgt6o3gMy4SKfXAL1QnIffIrE7aKLixqduW
// SIG // sqdCosnPGUFN4Ib5KpqjEWYw07t0MkvfY3v1mYovG8ch
// SIG // r1m1rtxEPJdQcdeh0sVV42neV8HR3jDA/czmTfsNv11P
// SIG // 6Z0eGTgvvM9YBS7vDaBQNdrvCScc1bN+NR4Iuto229Nf
// SIG // j950iEkSMIIE2jCCA8KgAwIBAgITMwAAALFxE3nfdfY1
// SIG // yAAAAAAAsTANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQgVGlt
// SIG // ZS1TdGFtcCBQQ0EgMjAxMDAeFw0xNjA5MDcxNzU2NTda
// SIG // Fw0xODA5MDcxNzU2NTdaMIGzMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5uQ2lw
// SIG // aGVyIERTRSBFU046QjFCNy1GNjdGLUZFQzIxJTAjBgNV
// SIG // BAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZpY2Uw
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCq
// SIG // pCSUbVjWW7yhvQ/t166a5Gfgm9GLYYSuYr3i+BudY+Z3
// SIG // SP/1qsDvnf0cPV2kbW6FhuacDFz6qy68wzR+kS+21Mri
// SIG // VlJTuyzmsl9aZsWf8nyRIYjwr2IFoHqFCQm4hfiyL2mk
// SIG // 2v1Hehkjcdsn/JGQpQ+TiGjOljoKR6FFzT9l+7q1CLKo
// SIG // juYKVdhlNePD6suyHf+B0G9gN3fzMUGWVp/7e6KYpCBR
// SIG // NcaNsp+plmTe0RTeJtZU9TECabGUbexZOVeZTfV8LD/p
// SIG // NXMaDbnWWr5Djo6Nt4f28HZM5yoSyjg1qLcnUJ0wBhR2
// SIG // V6VVW2BB0jH9z7ke+vDRjpbu4YEBadbnAgMBAAGjggEb
// SIG // MIIBFzAdBgNVHQ4EFgQUTlc994suFEtXsvwiXtPPtydE
// SIG // EDswHwYDVR0jBBgwFoAU1WM6XIoxkPNDe3xGG8UzaFqF
// SIG // bVUwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0cDovL2NybC5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvTWlj
// SIG // VGltU3RhUENBXzIwMTAtMDctMDEuY3JsMFoGCCsGAQUF
// SIG // BwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraS9jZXJ0cy9NaWNUaW1TdGFQ
// SIG // Q0FfMjAxMC0wNy0wMS5jcnQwDAYDVR0TAQH/BAIwADAT
// SIG // BgNVHSUEDDAKBggrBgEFBQcDCDANBgkqhkiG9w0BAQsF
// SIG // AAOCAQEAc+6N+7Rbw8FOmN9ho+sAogEspyWNPj5idZtu
// SIG // Aa+ZdTw68hQMGSS/yA0YYdE7kNLJJoIBEjOCfbIiF4Cq
// SIG // HobAzbIqt9vh5UJg97UJOUKx5LlM6/5Of/3mZeP43FOq
// SIG // +42auGAJWvQJDtvfGgpzANxBuDtOZ6sOBsi/aTtwSpth
// SIG // tT8Hcy1JfxmON/RmeB0qhfQliQAQNtlyE6tGJS0Mki16
// SIG // A8pk9/oKN4diOuYrC9M5ULO/eVbS7KHXJv84N5Ef5WoQ
// SIG // 1IcJugWISKr0qkow6l6TVW9CGYjYptOVG8rzr2CPU3C5
// SIG // QcfxzdZe7gDRfX4IGZTy3SC9398WVC/DTi94paH3zqGC
// SIG // A3kwggJhAgEBMIHjoYG5pIG2MIGzMQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYDVQQLEx5u
// SIG // Q2lwaGVyIERTRSBFU046QjFCNy1GNjdGLUZFQzIxJTAj
// SIG // BgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1wIFNlcnZp
// SIG // Y2WiJQoBATAJBgUrDgMCGgUAAxUAOrrfkyhl5HrT56P2
// SIG // 4qdEbliqU9KggcIwgb+kgbwwgbkxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdS
// SIG // ZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
// SIG // YXRpb24xDTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5D
// SIG // aXBoZXIgTlRTIEVTTjo0REU5LTBDNUUtM0UwOTErMCkG
// SIG // A1UEAxMiTWljcm9zb2Z0IFRpbWUgU291cmNlIE1hc3Rl
// SIG // ciBDbG9jazANBgkqhkiG9w0BAQUFAAIFANxFzHQwIhgP
// SIG // MjAxNzAyMDgxNjU3MjRaGA8yMDE3MDIwOTE2NTcyNFow
// SIG // dzA9BgorBgEEAYRZCgQBMS8wLTAKAgUA3EXMdAIBADAK
// SIG // AgEAAgIU0wIB/zAHAgEAAgIbOjAKAgUA3Ecd9AIBADA2
// SIG // BgorBgEEAYRZCgQCMSgwJjAMBgorBgEEAYRZCgMBoAow
// SIG // CAIBAAIDFuNgoQowCAIBAAIDB6EgMA0GCSqGSIb3DQEB
// SIG // BQUAA4IBAQBYgqYOxhjzFHzfKw5/yAuSb+KEDYtHuoCw
// SIG // KJ4oWiiwjMSwWVhdYPAYUhyoUy7rgMJnJ2t/Q0azkRC6
// SIG // 235h1GSqgPCnIWjWtSjv9dWRR0twgmXESu+x/KGqs13A
// SIG // CVDZspL7PVHKoPj037IFajymAjsbyYRu8LlQI3LoRZ/c
// SIG // jWar2LzqgxS1yzhn269l1JneJ+RrGO+2WOVDN+qjtQzL
// SIG // Vt1tbJVkTgVA0Dxop03hFk01CPpOlHS/EGelN18a30GY
// SIG // zDD8BhGESqQrQPqL3kM8IctaSGEbGNepbmprvKEpagyA
// SIG // ml7VmQXi+aS10f7vYFofgTypIWrGpjAxr8DSWX0Y8a/n
// SIG // MYIC9TCCAvECAQEwgZMwfDELMAkGA1UEBhMCVVMxEzAR
// SIG // BgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1JlZG1v
// SIG // bmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3JhdGlv
// SIG // bjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRpbWUtU3RhbXAg
// SIG // UENBIDIwMTACEzMAAACxcRN533X2NcgAAAAAALEwDQYJ
// SIG // YIZIAWUDBAIBBQCgggEyMBoGCSqGSIb3DQEJAzENBgsq
// SIG // hkiG9w0BCRABBDAvBgkqhkiG9w0BCQQxIgQgvPmXhmux
// SIG // bEzWHeo+SLpGq9O+iy8+BV7DkcnV5hG9wmkwgeIGCyqG
// SIG // SIb3DQEJEAIMMYHSMIHPMIHMMIGxBBQ6ut+TKGXketPn
// SIG // o/bip0RuWKpT0jCBmDCBgKR+MHwxCzAJBgNVBAYTAlVT
// SIG // MRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdS
// SIG // ZWRtb25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9y
// SIG // YXRpb24xJjAkBgNVBAMTHU1pY3Jvc29mdCBUaW1lLVN0
// SIG // YW1wIFBDQSAyMDEwAhMzAAAAsXETed919jXIAAAAAACx
// SIG // MBYEFFYXL3ClSZDH/LmDxBBezKo6KuEHMA0GCSqGSIb3
// SIG // DQEBCwUABIIBAB320q6b3rFgsQdICEdKIlnziBbbJsxw
// SIG // N7CvpGAivCzHp+9eNcHAtD3yET0Sl9vuZ5NmXQUlczDy
// SIG // hJwAm6j8V6/01LwgMrYPDFaWFVOjIQvHFlWKVFySeKSS
// SIG // LfO6a048COREGVo7BHnRTikcR6dSqXnkHngwNty+CBY0
// SIG // YrYNYF2h/3A+PKJ1kRv000Z/1bWCHKG9b4bqrusvrUkQ
// SIG // MGrS0ztkkYRcfj4Za0dCcF/XREGJ9NU1c8PZzIKjcklM
// SIG // vCFbBDHL7LVUOIgp8PAIxwM245n/P+81eN9kHJ5oxqdD
// SIG // zt0qtVl5D57uEDddXXW5Rp9adltvhf3E/SHpLEhPocSMgwU=
// SIG // End signature block
